#!/bin/env python

import os
from slack_bolt import App
import json
import sys

FILENAME = 'roles.json'

app = App(
    token=os.environ.get("SLACK_BOT_TOKEN"),
    signing_secret=os.environ.get("SLACK_SIGNING_SECRET")
)

def update_roles(username, channel, role):
    with open(FILENAME, 'r') as f:
        try:
            roles = json.load(f)
        except:
            sys.exit("La structure du fichier json est incorrecte !")

    if not channel in roles:
        roles[channel] = {}
    roles[channel][role] = username

    with open(FILENAME, 'w') as f:
        json.dump(roles, f)

def define_rode(client, command, say, role):
    channel_id = command['channel_id']
    try:
        username = command['text'][1:]
    except:
        username = command['user_name']
    users = client.users_list()['members']
    usernames = [user['name'] for user in users]
    if username in usernames:
        update_roles(username, channel_id, role)
        if role == 'cdp':
            text = f"<@{username}> est maintenant le chef de projet !"
        else:
            text = f"<@{username}> est maintenant le respo gestion de projet"
        say(text=text, channel=channel_id)
    else:
        text = "Nom d'utilisateur non reconnu :confused:"
        say(text=text, channel=channel_id)


@app.event("channel_created")
def join_channel(event, client):
    channel = event['channel']
    if channel['name'][0] == '2':
        client.conversations_join(channel=channel['id'])
        client.chat_postMessage(channel=channel['id'], text="Salut !")

@app.command('/cdp')
def define_cdp(ack, client, command, say):
    ack()
    define_rode(client, command, say, 'cdp')

@app.command('/gdp')
def define_cdp(ack, client, command, say):
    ack()
    define_rode(client, command, say, 'gdp')

if __name__ == "__main__":
    app.start(port=int(os.environ.get("PORT", 3000)))
