import os

from slack_sdk import WebClient
from slack_sdk.errors import SlackApiError

client = WebClient(token=os.environ.get("SLACK_BOT_TOKEN"))

try:
    result = client.conversations_list()
    for response in result:
        for channel in result["channels"]:
            if channel["name"][0] == '2':
                if not channel["is_archived"]:
                    client.conversations_join(channel=channel["id"])
                    client.chat_postMessage(channel=channel["id"], text="Salut ! Ceci est un test :grin:")

except SlackApiError as e:
    print(f"Error: {e}")
