import requests
import re

CONFIG = {
	"BASE": "https://www.beequick.fr/",
	"JE": "cne",
	"ADMIN_MAIL": "cne@ec-nantes.fr",
	"ADMIN_PASSWORD": "Jalcas80",
	"DEFAULT_FOLLOWER": 1125
}

CSRF_RE = re.compile('App.csrfToken=\\"(.+)\\"')

class BeequickClient:

	def admin():
		return BeequickClient(CONFIG["ADMIN_MAIL"],CONFIG["ADMIN_PASSWORD"])

	def __init__(self, username, password):
		self.jeUrl = CONFIG["BASE"] + CONFIG["JE"] + "/"
		self.headers = {}
		self.session = requests.Session()
		self.personnal_data = self.login(username, password).json()

	def get(self, path, params = {}):
		return self.session.get(self.jeUrl + path, params = params)

	def post(self, path, params = {}):
		return self.session.post(self.jeUrl + path, params = params)

	def loadCsrfToken(self):
		page = self.get("").text
		m = CSRF_RE.search(page)
		self.token = m.group(1)
		self.session.headers.update({"X-CSRF-Token": self.token})

	def login(self, username, password):
		self.loadCsrfToken()
		return self.post("login", {"email":username, "password": password})

	# Défaut : études actives
	def getEtudes(self, params = {}):
		return self.get("etudes", params).json()

	def getAllEtudes(self, params = {}):
		actives = self.getEtudes(params)
		params.update({"actif":0})
		inactives = self.getEtudes(params)
		return actives + inactives

	def getEtudeInformations(self, id, params = {}):
		return self.get("etudes/" + str(id), params).json()
	
	def getEtudeActions(self, id, params = {}):
		params.update({"etude_id":id})
		return self.get("actions", params).json()

	# Défaut : membres actifs
	def getMembres(self, params = {}):
		return self.get("etudiants", params).json()

	def getAllMembres(self, params = {}):
		actifs = self.getMembres(params)
		params.update({"actif":0})
		inactifs = self.getMembres(params)
		return actifs + inactifs