from BeequickClient import BeequickClient
import sqlite3

con = sqlite3.connect("../CNE.db")
db = con.cursor()

insert_req = "INSERT INTO etudes_labels_ids VALUES(:id, :nom, :abbreviation, :type)"
update_req = "UPDATE etudes_labels_ids SET id = :id, nom = :nom, abbreviation = :abbreviation, type = :type) WHERE id = :id"

bq = BeequickClient.admin()

labels = bq.get("config/labels", {"actif":"actif", "pipe_type":"etudes"})
print(labels)
labels = labels.json()
for label in labels:
	id = label["id"]
	new = db.execute("SELECT * FROM etudes_labels_ids WHERE id = :id", {"id": id}).fetchone() == None
	req = insert_req if new else update_req
	typ = "Provenance" if label["label_type_id"] == 3 else "Business Unit"
	label.update({"type": typ})
	db.execute(req, label)

con.commit()
con.close()