from __future__ import print_function

import os.path

from google.auth.transport.requests import Request
from google.oauth2 import service_account
from google_auth_oauthlib.flow import InstalledAppFlow
from googleapiclient.discovery import build
from googleapiclient.errors import HttpError

import sqlite3

con = sqlite3.connect("../CNE.db")
db = con.cursor()
values = db.execute("SELECT * FROM fb_posts").fetchall()

s1 = len(values) + 1

SCOPES = ['https://www.googleapis.com/auth/spreadsheets']
SPREADSHEET_ID = '1Rf_AmrKNkol--kKtWYJLHVYzL1ffTcpSjfuaSahRZx0'

creds = service_account.Credentials.from_service_account_file('token.json', scopes = SCOPES)

try:

    service = build('sheets', 'v4', credentials=creds)
    sheet = service.spreadsheets()

    body = { "values" : values }
    
    result = sheet.values().update(
        spreadsheetId = SPREADSHEET_ID,
        range = "A2:N" + str(s1),
        valueInputOption = "USER_ENTERED",
        body = body
    ).execute()

    print(result)

except HttpError as err:
    print(err)
