from FacebookClient import FacebookClient
import sqlite3

con = sqlite3.connect("../CNE.db")
db = con.cursor()

fb = FacebookClient()
posts = fb.getPosts()

reactions = ["like","wow","love","haha","sorry","anger"]
metrics = [
	"post_impressions", 
	"post_impressions_unique",
	"post_engaged_users"
]
for r in reactions:
	metrics.append("post_reactions_" + r + "_total")

insert_req = 	"INSERT INTO fb_posts" \
				"(fb_id, created_at, impressions, impressions_unique, " \
				"reactions_like, reactions_wow, reactions_love, " \
				"reactions_haha, reactions_sorry, reactions_anger, " \
				"engaged_users, message, story) " \
				"VALUES ( :fb_id, :created_at, :impressions, :impressions_unique, " \
				":reactions_like, :reactions_wow, :reactions_love, " \
				":reactions_haha, :reactions_sorry, :reactions_anger, " \
				":engaged_users, :message, :story) "
update_req = 	"UPDATE fb_posts " \
				"SET fb_id = :fb_id, created_at = :created_at, impressions = :impressions, impressions_unique = :impressions_unique, " \
				"reactions_like = :reactions_like, reactions_wow = :reactions_wow, reactions_love = :reactions_love, " \
				"reactions_haha = :reactions_haha, reactions_sorry = :reactions_sorry, reactions_anger = :reactions_anger, " \
				"engaged_users = :engaged_users, message = :message, story = :story " \
				"WHERE fb_id = :fb_id"

for post in posts:
	fb_id = post["id"]
	insights = fb.getInsights(fb_id, metrics)
	results = {}
	for metric in insights:
		value = metric["values"][0]["value"]
		results.update({metric["name"]:value})
	message = post["message"] if ("message" in post) else None
	story = post["story"] if ("story" in post) else None
	data = {
		"fb_id": fb_id,
		"created_at": post["created_time"],
		"impressions": results["post_impressions"],
		"impressions_unique": results["post_impressions_unique"],
		"engaged_users":results["post_engaged_users"],
		"message":message,
		"story":story
	}
	for r in reactions:
		data.update({"reactions_" + r : results["post_reactions_"+r+"_total"]})
	already = db.execute("SELECT * FROM fb_posts WHERE fb_id = :fb_id", {"fb_id":fb_id}).fetchone()
	req = insert_req if already == None else update_req
	db.execute(req,data)
	print(data)

con.commit()
con.close()