import os
from slack_bolt import App

app = App(
    token=os.environ.get("SLACK_BOT_TOKEN"),
    signing_secret=os.environ.get("SLACK_SIGNING_SECRET")
)

@app.event("channel_created")
def join_channel(event, client):
    channel = event['channel']
    if channel['name'][0] == '2':
        client.conversations_join(channel=channel['id'])
        client.chat_postMessage(channel=channel['id'], text="Salut !")

if __name__ == "__main__":
    app.start(port=int(os.environ.get("PORT", 3000)))
